//=============================================================================
// MenuPetStats
//=============================================================================
class CCColorPicker expands MenuUIWindow;

var int CurMS;
var MenuUIActionButtonWindow exitButton;
var localized string exitButtonText;

var CCColorPickerButton ColorSquares[10];

var int XPos[10];
var int YPos[10];

var Texture ColTex[10];

var bool bSpawnedSquares;

#exec TEXTURE IMPORT NAME="CCBG160" FILE="Textures\PerkScreenBG160.pcx" GROUP=UI FLAGS=2

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window... it's way down there...
// In the meantime, here's a lot of precautionary vomit!
// ----------------------------------------------------------------------

function bool CanPushScreen(Class <DeusExBaseWindow> newScreen)
{
 return false;
}

function bool CanStack()
{
 return false;
}

event bool VirtualKeyPressed(EInputKey key, bool bRepeat)
{
 /*if (key == IK_M)
  {
   TNMDreamScapePlayer(Ralph.Owner).ShowImagesWindow();
   return true;
  }*/
 return false;
}

event bool RawKeyPressed(EInputKey key, EInputState iState, bool bRepeat)
{
 /*if (key == IK_M)
  {
   TNMDreamScapePlayer(Ralph.Owner).ShowImagesWindow();
   return true;
  }*/
 return false;
}

event InitWindow()
{
 local int j;
 
	Super.InitWindow();
	
	for(j=0; j<10; j++)
	{
	 ColorSquares[j] = CCColorPickerButton(NewChild(Class'CCColorPickerButton'));
	 ColorSquares[j].SetPos(YPos[j], XPos[j]);
	 ColorSquares[j].ColRep = j;
	 ColorSquares[j].SetTextures(ColTex[j]);
	}
}

function ShowButtons()
{
 local int j;
 
	for(j=0; j<10; j++)
	{
	 ColorSquares[j].Show(True);
	}
}

function HideButtons()
{
 local int j;
 
	for(j=0; j<10; j++)
	{
	 ColorSquares[j].Show(False);
	}
}

function UpdateButtons()
{
 local int j;
 
	for(j=0; j<10; j++)
	{
	 ColorSquares[j].SetPos(X + XPos[j], Y + YPos[j]);
	}
}

function bool ButtonActivated( Window buttonPressed )
{
	local bool bHandled;
	local name TempName;
	
	bHandled = True;
	
	Super.ButtonActivated(buttonPressed);
	
	UpdateButtons();
	
	return bHandled;
}

     /*clientTextures(1)=Texture'DeusExUI.UserInterface.SkillsBackground_2'
     clientTextures(2)=Texture'DeusExUI.UserInterface.SkillsBackground_3'
     clientTextures(3)=Texture'DeusExUI.UserInterface.SkillsBackground_4'
     clientTextures(4)=Texture'DeusExUI.UserInterface.SkillsBackground_5'
     clientTextures(5)=Texture'DeusExUI.UserInterface.SkillsBackground_6'

     ClientWidth=604
     ClientHeight=361*/

defaultproperties
{
     XPos(0)=25
     XPos(1)=25
     XPos(2)=25
     XPos(3)=25
     XPos(4)=25
     XPos(5)=57
     XPos(6)=57
     XPos(7)=57
     XPos(8)=57
     XPos(9)=57

     YPos(0)=0
     XPos(1)=32
     XPos(2)=64
     XPos(3)=96
     XPos(4)=128
     XPos(5)=0
     XPos(6)=32
     XPos(7)=64
     XPos(8)=96
     XPos(9)=128

     ColTex(0)=Texture'CCMBlack'
     ColTex(1)=Texture'CCMDGray'
     ColTex(2)=Texture'CCMGray'
     ColTex(3)=Texture'CCMWhite'
     ColTex(4)=Texture'CCMRed'
     ColTex(5)=Texture'CCMOrange'
     ColTex(6)=Texture'CCMGold'
     ColTex(7)=Texture'CCMGreen'
     ColTex(8)=Texture'CCMBlue'
     ColTex(9)=Texture'CCPurple'

     Title=""
     exitButtonText="Done"
     ClientWidth=160
     ClientHeight=64

     clientTextures(0)=Texture'CCBG160'

     bActionButtonBarActive=True
     bUsesHelpWindow=False
     ScreenType=ST_Persona
     TextureRows=2
     TextureCols=3
}
